/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.wcl;

import com.ibm.hwmca.fw.servlet.pmod.PanelModel;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmTableModel;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.WclActionBoundProxyRequest;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.WclPendingModelSelection;
import com.ibm.hwmca.fw.servlet.pmod.impl.wcl.WclProxyRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.psw.wcl.components.table.IExtendedTableModel;
import com.ibm.psw.wcl.components.table.ITableFilter;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.components.table.WTableColumn;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.ExtendedListSelectionEvent;
import com.ibm.psw.wcl.core.IExtendedListSelectionListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelListener;

public class WclGlueTableModel
implements IExtendedTableModel {
    public static final String TRACE_MASKT = "XPMWGLTT";
    public static final String TRACE_MASKF = "XPMWGLTF";
    private static final int[] EMPTY_SELECTION = new int[0];
    private boolean dirty = false;
    private PmTableModel model = null;
    private List tableModelListeners = null;
    private List listSelectionListeners = null;
    private int selectionMode = 0;
    private int[] viewRowIndicies;
    private PanelModel panelModel;
    private boolean notifyImmediate;
    private WTable wTable;

    public WclGlueTableModel(PmTableModel model, PanelModel panelModel, boolean notifyImmediate) {
        this.model = model;
        this.panelModel = panelModel;
        this.notifyImmediate = notifyImmediate;
        this.tableModelListeners = new ArrayList();
        this.listSelectionListeners = new ArrayList();
        this.dirty = true;
    }

    private void setValueOnModel(Object value, int row, int col) {
        Trace.trace(TRACE_MASKT, "setValueOnModel( " + value + "," + row + "," + col + ")");
        Object fValue = value;
        int fRow = row;
        int fCol = col;
        if (this.notifyImmediate) {
            Trace.trace(TRACE_MASKT, "notifySelect = Immediate, queueing action bound");
            class ActionBoundUpdate
            extends NonActionBoundUpdate
            implements WclActionBoundProxyRequest {
                private final /* synthetic */ int val$fCol;
                private final /* synthetic */ int val$fRow;
                private final /* synthetic */ Object val$fValue;

                ActionBoundUpdate(Object source, int val$fCol, int val$fRow, Object val$fValue) {
                    class NonActionBoundUpdate
                    extends WclProxyRequest {
                        private final /* synthetic */ Object val$fValue;
                        private final /* synthetic */ int val$fRow;
                        private final /* synthetic */ int val$fCol;

                        NonActionBoundUpdate(Object source, Object val$fValue, int val$fRow, int val$fCol) {
                            super(source);
                            this.val$fValue = val$fValue;
                            this.val$fRow = val$fRow;
                            this.val$fCol = val$fCol;
                        }

                        public void execute() {
                            Trace.trace(WclGlueTableModel.TRACE_MASKF, "updating model selection");
                            WclGlueTableModel.this.model.setValueAt(this.val$fValue, this.val$fRow, this.val$fCol);
                        }
                    }
                    super(source, val$fValue, val$fRow, val$fCol);
                    this.val$fCol = val$fCol;
                    this.val$fRow = val$fRow;
                    this.val$fValue = val$fValue;
                }
            }
            this.panelModel.getImplAccess().getWclEventProxyManager().queueRequest(new ActionBoundUpdate((Object)this.model, fCol, fRow, fValue));
        } else {
            Trace.trace(TRACE_MASKT, "notifySelect != Immediate, queueing non action bound");
            this.panelModel.getImplAccess().getWclEventProxyManager().queueRequest(new NonActionBoundUpdate(this.model, fValue, fRow, fCol));
        }
    }

    private void setSelectionOnModel(int[] newSel, int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "setSelectionOnModel( " + newSel + "," + index0 + "," + index1 + ", " + ac + ")");
        if (this.notifyImmediate) {
            Trace.trace(TRACE_MASKT, "notifySelect = Immediate, queueing action bound");
            this.panelModel.getImplAccess().getWclEventProxyManager().queueRequest(new ActionBoundUpdate(this.model, newSel, index0, index1, ac));
        } else {
            Trace.trace(TRACE_MASKT, "notifySelect != Immediate, queueing non action bound");
            this.panelModel.getImplAccess().getWclEventProxyManager().queueRequest(new NonActionBoundUpdate(this.model, newSel, index0, index1, ac));
        }
    }

    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    public int getRowCount() {
        return this.model.getRowCount();
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.model.setValueAt(value, rowIndex, columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.model.getValueAt(rowIndex, columnIndex);
    }

    public String getColumnName(int columnIndex) {
        return this.model.getColumnName(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.model.getColumnClass(columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.model.isCellEditable(rowIndex, columnIndex);
    }

    public void addTableModelListener(TableModelListener l) {
        if (l != null) {
            this.tableModelListeners.add(l);
        }
    }

    public void removeTableModelListener(TableModelListener l) {
        if (l != null) {
            this.tableModelListeners.remove(l);
        }
    }

    public boolean isSelectedIndex(int index) {
        int[] selected = this.model.getSelected();
        int newIndex = this.getModelRowIndex(index);
        if (selected != null) {
            for (int i = 0; i < selected.length; ++i) {
                if (selected[i] != newIndex) continue;
                return true;
            }
        }
        return false;
    }

    public void setSelectionInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "setSelectionInterval(" + index0 + "," + index1 + ")");
        index0 = this.getModelRowIndex(index0);
        index1 = this.getModelRowIndex(index1);
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                index1 = index0;
            }
            int[] currentSel = this.getSelectedRows();
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSel = new int[++newSelIntervalSize];
            for (int i = 0; i < newSelIntervalSize; ++i) {
                newSel[i] = index0 == index1 ? index0 : (index0 < index1 ? index0 + i : index1 + i);
            }
            if (!Arrays.equals(currentSel, newSel)) {
                this.setSelectionOnModel(newSel, index0, index1, ac);
            }
        }
    }

    public void addSelectionInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "addSelectionInterval(" + index0 + "," + index1 + ")");
        ArrayList accumulator = new ArrayList();
        this.panelModel.getImplAccess().getWclEventProxyManager().findRequests(this.model, accumulator);
        NonActionBoundUpdate lastUpdate = accumulator.isEmpty() ? null : (NonActionBoundUpdate)accumulator.get(accumulator.size() - 1);
        index0 = this.getModelRowIndex(index0);
        index1 = this.getModelRowIndex(index1);
        if (this.selectionMode != -1) {
            int i;
            int[] currentSel;
            if (lastUpdate == null) {
                currentSel = this.getSelectedRows();
                if (this.selectionMode == 0) {
                    index1 = index0;
                    currentSel = EMPTY_SELECTION;
                }
            } else if (this.selectionMode == 0) {
                index1 = index0;
                currentSel = EMPTY_SELECTION;
                Trace.trace(TRACE_MASKF, "mjh: single select, overriding currentSel for addSelectionInterval");
            } else {
                currentSel = lastUpdate.newSelection;
            }
            Trace.trace(TRACE_MASKF, "mjh: currentSel.length: " + currentSel.length);
            int newSelIntervalSize = index0 - index1;
            if (newSelIntervalSize < 0) {
                newSelIntervalSize *= -1;
            }
            int[] newSelAddition = new int[++newSelIntervalSize];
            for (int i2 = 0; i2 < newSelAddition.length; ++i2) {
                newSelAddition[i2] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i2);
            }
            Trace.trace(TRACE_MASKT, "mjh: newSelAddition.length " + newSelAddition.length);
            int uniqueEntries = currentSel.length;
            for (int i3 = 0; i3 < newSelAddition.length; ++i3) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != newSelAddition[i3]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (found) continue;
                ++uniqueEntries;
            }
            Trace.trace(TRACE_MASKT, "mjh: unique entries: " + uniqueEntries);
            int[] newSelection = new int[uniqueEntries];
            System.arraycopy(currentSel, 0, newSelection, 0, currentSel.length);
            uniqueEntries = currentSel.length;
            for (i = 0; i < newSelAddition.length; ++i) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != newSelAddition[i]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (found) continue;
                newSelection[uniqueEntries++] = newSelAddition[i];
            }
            Arrays.sort(newSelection);
            if (newSelection.length != currentSel.length) {
                if (lastUpdate == null) {
                    this.setSelectionOnModel(newSelection, index0, index1, ac);
                } else {
                    lastUpdate.newSelection = newSelection;
                    lastUpdate.first = newSelection[0];
                    lastUpdate.last = newSelection[newSelection.length - 1];
                    Trace.trace(TRACE_MASKF, "mjh: new selection data:");
                    Trace.trace(TRACE_MASKF, "first=" + lastUpdate.first + "last=" + lastUpdate.last);
                    for (i = 0; i < lastUpdate.newSelection.length; ++i) {
                        Trace.trace(TRACE_MASKF, "\t" + newSelection[i]);
                    }
                }
            }
        }
    }

    public void clearSelection(AContext ac) {
        Trace.trace(TRACE_MASKT, "clearSelection()");
        if (this.selectionMode != -1) {
            this.setSelectionOnModel(EMPTY_SELECTION, -1, -1, ac);
        }
    }

    public void removeSelectionInterval(int index0, int index1, AContext ac) {
        Trace.trace(TRACE_MASKT, "removeSelectionInterval(" + index0 + "," + index1 + ")");
        ArrayList accumulator = new ArrayList();
        this.panelModel.getImplAccess().getWclEventProxyManager().findRequests(this.model, accumulator);
        NonActionBoundUpdate lastUpdate = accumulator.isEmpty() ? null : (NonActionBoundUpdate)accumulator.get(accumulator.size() - 1);
        index0 = this.getModelRowIndex(index0);
        index1 = this.getModelRowIndex(index1);
        if (this.selectionMode != -1) {
            int i;
            if (this.selectionMode == 0) {
                index1 = index0;
            }
            int[] currentSel = lastUpdate == null ? this.getSelectedRows() : lastUpdate.newSelection;
            int remSelIntervalSize = index0 - index1;
            if (remSelIntervalSize < 0) {
                remSelIntervalSize *= -1;
            }
            int[] selSubtraction = new int[++remSelIntervalSize];
            for (int i2 = 0; i2 < selSubtraction.length; ++i2) {
                selSubtraction[i2] = index0 == index1 ? index0 : (index0 > index1 ? index1 - 1 : index0 + i2);
            }
            int uniqueEntries = currentSel.length;
            for (int i3 = 0; i3 < selSubtraction.length; ++i3) {
                boolean found = false;
                for (int j = 0; j < currentSel.length; ++j) {
                    if (currentSel[j] != selSubtraction[i3]) continue;
                    found = true;
                    j = currentSel.length;
                }
                if (!found) continue;
                --uniqueEntries;
            }
            int[] newSelection = new int[uniqueEntries];
            uniqueEntries = 0;
            for (i = 0; i < currentSel.length; ++i) {
                boolean found = false;
                for (int j = 0; j < selSubtraction.length; ++j) {
                    if (currentSel[i] != selSubtraction[j]) continue;
                    found = true;
                    j = selSubtraction.length;
                }
                if (found) continue;
                newSelection[uniqueEntries++] = currentSel[i];
            }
            Arrays.sort(newSelection);
            if (newSelection.length != currentSel.length) {
                if (lastUpdate == null) {
                    this.setSelectionOnModel(newSelection, index0, index1, ac);
                } else {
                    lastUpdate.newSelection = newSelection;
                    if (newSelection.length > 0) {
                        lastUpdate.first = newSelection[0];
                        lastUpdate.last = newSelection[newSelection.length - 1];
                    } else {
                        lastUpdate.first = -1;
                        lastUpdate.last = -1;
                    }
                    Trace.trace(TRACE_MASKF, "mjh: new selection data:");
                    Trace.trace(TRACE_MASKF, "first=" + lastUpdate.first + "last=" + lastUpdate.last);
                    for (i = 0; i < lastUpdate.newSelection.length; ++i) {
                        Trace.trace(TRACE_MASKF, "\t" + newSelection[i]);
                    }
                }
            }
        }
    }

    public int getMinSelectionIndex() {
        int[] selected = this.model.getSelected();
        if (selected != null && selected.length > 0) {
            return selected[0];
        }
        return -1;
    }

    public int getMaxSelectionIndex() {
        int[] selected = this.model.getSelected();
        if (selected != null && selected.length > 0) {
            return selected[selected.length - 1];
        }
        return -1;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void addListSelectionListener(IExtendedListSelectionListener x) {
        if (x != null) {
            this.listSelectionListeners.add(x);
        }
    }

    public boolean isSelectionEmpty() {
        int[] selected = this.model.getSelected();
        return selected == null || selected.length == 0;
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectedRowCount() {
        int[] selected = this.getSelectedModelRows();
        int count = 0;
        for (int i = 0; i < selected.length; ++i) {
            if (this.getViewRowIndex(selected[i]) == Integer.MAX_VALUE) continue;
            ++count;
        }
        return count;
    }

    public int[] getSelectedModelRows() {
        int[] selected = this.model.getSelected();
        return selected == null ? EMPTY_SELECTION : selected;
    }

    public void removeListSelectionListener(IExtendedListSelectionListener x) {
        if (x != null) {
            this.listSelectionListeners.remove(x);
        }
    }

    public int[] getSelectedRows() {
        int[] selected = this.model.getSelected();
        if (this.viewRowIndicies == null) {
            return selected;
        }
        int[] viewSelected = new int[selected.length];
        int j = 0;
        for (int i = 0; i < selected.length; ++i) {
            if (this.getViewRowIndex(selected[i]) == Integer.MAX_VALUE) continue;
            viewSelected[j++] = selected[i];
        }
        int[] finalSelected = new int[j];
        System.arraycopy(viewSelected, 0, finalSelected, 0, j);
        return finalSelected;
    }

    public void selectAll(AContext ac) {
        if (this.selectionMode != -1) {
            if (this.selectionMode == 0) {
                if (this.model.getRowCount() > 0) {
                    this.setSelectionOnModel(new int[]{0}, 0, this.model.getRowCount(), ac);
                }
            } else {
                int[] newSel = new int[this.model.getRowCount()];
                for (int i = 0; i < newSel.length; ++i) {
                    newSel[i] = i;
                }
                this.setSelectionOnModel(newSel, 0, this.model.getRowCount(), ac);
            }
        }
    }

    public int getModelRowIndex(int viewRow) {
        return this.viewRowIndicies == null ? viewRow : this.viewRowIndicies[viewRow];
    }

    public int getSelectedModelRowCount() {
        int[] currentSel = this.model.getSelected();
        return currentSel == null ? 0 : currentSel.length;
    }

    public boolean isSelectedModelIndex(int index) {
        int[] currentSel = this.model.getSelected();
        if (currentSel == null) {
            return false;
        }
        for (int i = 0; i < currentSel.length; ++i) {
            if (currentSel[i] != index) continue;
            return true;
        }
        return false;
    }

    public int getTotalRows() {
        return this.model.getRowCount();
    }

    public void tableStateChanged(int stateID, WTable table) {
        int i;
        this.wTable = table;
        if (this.viewRowIndicies == null || stateID == 0 || stateID == 1 || stateID == 2) {
            this.viewRowIndicies = new int[this.getTotalRows()];
        }
        WTableColumn[] filteredColumns = table.getFilteredColumns();
        int[] filterIndicies = new int[filteredColumns.length];
        for (i = 0; i < filterIndicies.length; ++i) {
            filterIndicies[i] = filteredColumns[i].getModelIndex();
        }
        for (i = 0; i < this.viewRowIndicies.length; ++i) {
            this.viewRowIndicies[i] = i;
            for (int j = 0; j < filteredColumns.length; ++j) {
                ITableFilter filter = filteredColumns[j].getFilter();
                if (filter.matches(this.model.getValueAt(i, filterIndicies[j]))) continue;
                this.viewRowIndicies[i] = Integer.MAX_VALUE;
                j = filteredColumns.length;
            }
        }
        WTableColumn[] sortedColumns = table.getSortedColumns();
        int[] sortIndicies = new int[sortedColumns.length];
        for (int i2 = 0; i2 < sortIndicies.length; ++i2) {
            sortIndicies[i2] = sortedColumns[i2].getModelIndex();
        }
        this.quicksort(0, this.viewRowIndicies.length - 1, sortedColumns, sortIndicies);
        if (this.tableModelListeners.size() > 0) {
            this.setStateDirty(false);
        } else {
            this.setStateDirty(true);
        }
    }

    private void quicksort(int low, int high, WTableColumn[] sortedColumns, int[] sortIndicies) {
        if (high > low) {
            int pivot = this.partition(low, high, sortedColumns, sortIndicies);
            this.quicksort(low, pivot - 1, sortedColumns, sortIndicies);
            this.quicksort(pivot + 1, high, sortedColumns, sortIndicies);
        }
    }

    private int partition(int low, int high, WTableColumn[] sortedColumns, int[] sortIndicies) {
        int swap;
        int j = low;
        for (int i = low + 1; i <= high; ++i) {
            if (this.isSorted(this.viewRowIndicies[i], this.viewRowIndicies[low], sortedColumns, sortIndicies)) continue;
            swap = this.viewRowIndicies[i];
            this.viewRowIndicies[i] = this.viewRowIndicies[++j];
            this.viewRowIndicies[j] = swap;
        }
        int pivot = j;
        swap = this.viewRowIndicies[low];
        this.viewRowIndicies[low] = this.viewRowIndicies[pivot];
        this.viewRowIndicies[pivot] = swap;
        return pivot;
    }

    private boolean isSorted(int row1, int row2, WTableColumn[] sortedColumns, int[] sortIndicies) {
        try {
            for (int i = 0; i < sortedColumns.length; ++i) {
                int compValue;
                Object o1 = this.model.getValueAt(row1, sortIndicies[i]);
                Object o2 = this.model.getValueAt(row2, sortIndicies[i]);
                Comparator comparator = sortedColumns[i].getComparator();
                if (comparator == null) {
                    comparator = Collator.getInstance();
                }
                if ((compValue = comparator.compare(o1, o2)) == 0) continue;
                if (sortedColumns[i].isSortedAscending() && compValue > 0) {
                    return false;
                }
                if (sortedColumns[i].isSortedAscending() || compValue >= 0) continue;
                return false;
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, e);
        }
        return true;
    }

    public int getViewRowIndex(int modelRow) {
        if (this.viewRowIndicies == null) {
            Trace.trace(TRACE_MASKT, "getViewRowIndex(" + modelRow + "): " + modelRow);
        }
        for (int i = 0; i < this.viewRowIndicies.length; ++i) {
            if (this.viewRowIndicies[i] != modelRow) continue;
            Trace.trace(TRACE_MASKT, "getViewRowIndex(" + modelRow + "): " + i);
            return i;
        }
        return modelRow;
    }

    public int getViewRowCount() {
        int totalRows = this.getTotalRows();
        if (this.viewRowIndicies == null) {
            return totalRows;
        }
        if (totalRows != this.viewRowIndicies.length) {
            if (this.wTable != null) {
                this.tableStateChanged(0, this.wTable);
            } else {
                return totalRows;
            }
        }
        int count = 0;
        for (int i = 0; i < this.viewRowIndicies.length; ++i) {
            if (this.viewRowIndicies[i] == Integer.MAX_VALUE) continue;
            ++count;
        }
        return count;
    }

    public void setStateDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isStateDirty() {
        return this.dirty;
    }

    class ActionBoundUpdate
    extends NonActionBoundUpdate
    implements WclActionBoundProxyRequest {
        ActionBoundUpdate(Object source, int[] newSelection, int first, int last, AContext aContext) {
            super(source, newSelection, first, last, aContext);
        }
    }

    class NonActionBoundUpdate
    extends WclProxyRequest
    implements WclPendingModelSelection {
        int[] newSelection;
        int first;
        int last;
        AContext aContext;

        NonActionBoundUpdate(Object source, int[] newSelection, int first, int last, AContext aContext) {
            super(source);
            this.newSelection = newSelection;
            this.first = first;
            this.last = last;
            this.aContext = aContext;
        }

        public Object getSelected() {
            return this.newSelection;
        }

        public void execute() {
            Trace.trace(WclGlueTableModel.TRACE_MASKF, "updating model selection");
            WclGlueTableModel.this.model.setSelected(this.newSelection);
            this.fireEvents();
        }

        protected void fireEvents() {
            Trace.trace(WclGlueTableModel.TRACE_MASKF, "about to fire events");
            ExtendedListSelectionEvent e = new ExtendedListSelectionEvent((Object)WclGlueTableModel.this, this.first, this.last, this.aContext);
            Iterator iterator = ((List)((ArrayList)WclGlueTableModel.this.listSelectionListeners).clone()).iterator();
            while (iterator.hasNext()) {
                IExtendedListSelectionListener listener = (IExtendedListSelectionListener)iterator.next();
                listener.valueChanged(e);
            }
            Trace.trace(WclGlueTableModel.TRACE_MASKF, "fired events");
        }
    }
}

